--
--  Copyright 2011 Autodesk, Inc. All rights reserved.
--
rollout DYNexposure ""
(
  ---SECTION 1 - SET UP LOCAL VARIABLES---
  local LOCexp
  local LOCspinStartValue
  local LOCundoState = on

  ---SECTION 2 - DEFINE LOCAL FUNCTIONS---
  fn DYNFUNsetupExpParams =
  (
    DYNexposure.LOCexp                        = SceneExposureControl.exposureControl
    DYNexposure.GBEXPgroup01.text             = DYNuiResourcesGroups[67]
    DYNexposure.GBEXPgroup02.text             = DYNuiResourcesGroups[22]
    DYNexposure.GBEXPgroup01.pos.x            = 4
    DYNexposure.GBEXPgroup02.pos.x            = 4
    DYNexposure.GBEXPgroup01.height           = 62
    DYNexposure.GBEXPgroup02.height           = 83
    DYNexposure.CODYNcolor.color              = color 255 255 255
    DYNexposure.CODYNcolor.enabled            = true
    DYNexposure.CODYNcolor.pos                = [2141,215]
    DYNexposure.SPEXPvalue.pos                = [2000,171]
    DYNexposure.SPEXPmidT.pos                 = [2000,192]
    DYNexposure.SPEXPscale.pos                = [2000,213]
    DYNexposure.SPEXPbright.pos               = [2000,103]
    DYNexposure.SPEXPcontr.pos                = [2000,124]
    DYNexposure.DDDYNpreset.pos.x             = 2019
    DYNexposure.RBDYNexpMode.pos.x            = 2019
    DYNexposure.LBEXPbright.pos               = [2019,104]
    DYNexposure.LBEXPcontr.pos                = [2019,125]

    DYNexposure.LBEXPvalue.pos                = [2019,172]
    DYNexposure.LBEXPmidT.pos                 = [2019,193]
    DYNexposure.LBEXPscale.pos                = [2019,214]
    DYNexposure.LBDYN1.pos                    = [2019,201]
    DYNexposure.LBDYN2.pos                    = [2019,228]
    DYNexposure.LBDYN3.pos                    = [2019,255]
    DYNexposure.DDDYN1.pos                    = [2088,197]
    DYNexposure.DDDYN2.pos                    = [2088,224]
    DYNexposure.DDDYN3.pos                    = [2088,251]
    DYNexposure.CBEXPcheck1.pos               = [2019,238]
    DYNexposure.CBEXPcheck2.pos               = [2019,258]
    DYNexposure.CBEXPcheck3.pos               = [2019,278]
    DYNexposure.CBEXPcheck4.pos               = [2019,298]
    DYNexposure.DDDYN1.items                  = #()
    DYNexposure.DDDYN2.items                  = #()
    DYNexposure.DDDYN3.items                  = #()
    DYNexposure.GBEXPgroup02.pos              = [4,153]
    DYNexposure.GBDYNgroup03.pos.x            = 2012
    DYNexposure.RBDYNphysicalMode.pos.x       = 2019
    DYNexposure.SPDYNphysicalScale.pos.x      = 2000
    DYNexposure.SPDYNexposureV.pos.x          = 2088
    DYNexposure.LBDYNshutter.pos.x            = 2019
    DYNexposure.SPDYNshutter.pos.x            = 2088
    DYNexposure.LBDYNfStop.pos.x              = 2019
    DYNexposure.SPDYNfStop.pos.x              = 2088
    DYNexposure.LBDYNfilmISO.pos.x            = 2019
    DYNexposure.SPDYNfilmISO.pos.x            = 2088

    DYNexposure.LBDYNhighlights.pos.x         = 2019
    DYNexposure.SPDYNhighlights.pos.x         = 2088
    DYNexposure.LBDYNmidtones.pos.x           = 2019
    DYNexposure.SPDYNmidtones.pos.x           = 2088
    DYNexposure.LBDYNshadows.pos.x            = 2019
    DYNexposure.SPDYNshadows.pos.x            = 2088
    DYNexposure.LBDYNsaturation.pos.x         = 2019
    DYNexposure.SPDYNsaturation.pos.x         = 2088
    DYNexposure.LBDYNwhitepointKelvin.pos.x   = 2019
    DYNexposure.SPDYNwhitepointKelvin.pos.x   = 2088
    DYNexposure.LBDYNvignetting.pos.x         = 2019
    DYNexposure.SPDYNvignetting.pos.x         = 2088

    for i in DYNexposure.controls do i.enabled= true
    DYNexposure.DDDYN1.enabled                = false
    DYNexposure.DDDYN2.enabled                = false
    DYNexposure.DDDYN3.enabled                = false

    --- Populate List of Exposure Control Types
    local LOCexpTypeArray = #(DYNuiResourcesLabels[303], DYNuiResourcesLabels[304], DYNuiResourcesLabels[305], DYNuiResourcesLabels[306], DYNuiResourcesLabels[307], DYNuiResourcesLabels[308])
    DYNexposure.DDDYNexposures.items =  LOCexpTypeArray

    if DYNexposure.LOCexp == undefined then
    (
      for i in DYNexposure.controls do i.enabled = false
      DYNexposure.LBEXPbright.text            = DYNuiResourcesLabels[281]
      DYNexposure.LBEXPcontr.text             = DYNuiResourcesLabels[282]
      DYNexposure.SPEXPbright.range           = [0,200,0]
      DYNexposure.SPEXPcontr.range            = [0,100,0]
      DYNexposure.DDDYNexposures.enabled      = true
      DYNexposure.DDDYNexposures.selection    = 1
      DYNexposure.CBEXPonOff.checked          = false
      DYNamite.dnExposeNode.forecolor         = DYNFUNdnColor (DYNINIgreyedOutColor)
      DYNexposure.GBEXPgroup01.pos.x          = 2012
      DYNexposure.GBEXPgroup02.pos.x          = 2012
    )
    else
    (
      DYNamite.dnExposeNode.forecolor         = DYNFUNdnColor (if DYNexposure.LOCexp.active then (((colorMan.getColor #text) as color) * 255) else DYNINIgreyedOutColor)
      DYNexposure.CBEXPonOff.checked          = DYNexposure.LOCexp.active
      DYNexposure.CBEXPprocBG.checked         = DYNexposure.LOCexp.processBG

      --- For Linear Exposure Controls
      if classof DYNexposure.LOCexp == Linear_Exposure_Control then
      (
        DYNexposure.DDDYNexposures.selection  = 2
        DYNexposure.GBEXPgroup02.height       = 109
        DYNexposure.SPEXPvalue.pos            = [(DYNiniExplorerWidth - 39),171]
        DYNexposure.CODYNcolor.pos            = [(DYNiniExplorerWidth - 57),215]
        DYNexposure.LBEXPbright.pos           = [13,104]
        DYNexposure.LBEXPcontr.pos            = [13,125]
        DYNexposure.SPEXPbright.pos           = [(DYNiniExplorerWidth - 39),103]
        DYNexposure.SPEXPcontr.pos            = [(DYNiniExplorerWidth - 39),124]
        DYNexposure.SPEXPmidT.pos             = [2159,192]
        DYNexposure.LBEXPmidT.pos             = [2019,193]
        DYNexposure.SPEXPscale.pos            = [(DYNiniExplorerWidth - 39),192]
        DYNexposure.LBEXPscale.pos            = [13,193]
        DYNexposure.LBEXPvalue.pos            = [13,172]
        DYNexposure.CBEXPcheck1.pos           = [13,218]
        DYNexposure.CBEXPcheck2.pos           = [13,238]
        DYNexposure.LBEXPbright.text          = DYNuiResourcesLabels[281]
        DYNexposure.LBEXPcontr.text           = DYNuiResourcesLabels[282]
        DYNexposure.SPEXPbright.range         = [0,200,DYNexposure.LOCexp.brightness]
        DYNexposure.SPEXPcontr.range          = [0,100,DYNexposure.LOCexp.contrast]
        DYNexposure.SPEXPvalue.value          = DYNexposure.LOCexp.exposureValue
        DYNexposure.SPEXPmidT.value           = 0.01; DYNexposure.SPEXPmidT.enabled = false; DYNexposure.LBEXPmidT.enabled = false
        DYNexposure.SPEXPscale.value          = DYNexposure.LOCexp.physicalScale
        DYNexposure.CBEXPcheck1.checked       = DYNexposure.LOCexp.chromaticAdaptation
        DYNexposure.CBEXPcheck2.checked       = DYNexposure.LOCexp.colorDifferentiation
        DYNexposure.CODYNcolor.color          = DYNexposure.LOCexp.whiteColor
      )

      --- For Logarithmic Exposure Control
      if classof DYNexposure.LOCexp == Logarithmic_Exposure_Control then
      (
        DYNexposure.DDDYNexposures.selection  = 3
        DYNexposure.GBEXPgroup02.height       = 149
        DYNexposure.LBEXPbright.pos           = [13,104]
        DYNexposure.LBEXPcontr.pos            = [13,125]
        DYNexposure.SPEXPbright.pos           = [(DYNiniExplorerWidth - 39),103]
        DYNexposure.SPEXPcontr.pos            = [(DYNiniExplorerWidth - 39),124]
        DYNexposure.CODYNcolor.pos            = [(DYNiniExplorerWidth - 57),215]
        DYNexposure.SPEXPvalue.pos            = [2159,171]
        DYNexposure.SPEXPmidT.pos             = [(DYNiniExplorerWidth - 39),171]
        DYNexposure.SPEXPscale.pos            = [(DYNiniExplorerWidth - 39),192]
        DYNexposure.LBEXPvalue.pos            = [2019,172]
        DYNexposure.LBEXPmidT.pos             = [13,172]
        DYNexposure.LBEXPscale.pos            = [13,193]
        DYNexposure.CBEXPcheck1.pos           = [13,218]
        DYNexposure.CBEXPcheck2.pos           = [13,238]
        DYNexposure.CBEXPcheck3.pos           = [13,258]
        DYNexposure.CBEXPcheck4.pos           = [13,278]
        DYNexposure.LBEXPbright.text          = DYNuiResourcesLabels[281]
        DYNexposure.LBEXPcontr.text           = DYNuiResourcesLabels[282]
        DYNexposure.SPEXPbright.range         = [0,200,DYNexposure.LOCexp.brightness]
        DYNexposure.SPEXPcontr.range          = [0,100,DYNexposure.LOCexp.contrast]
        DYNexposure.SPEXPvalue.value          = 0; DYNexposure.SPEXPvalue.enabled = false; DYNexposure.LBEXPvalue.enabled = false
        DYNexposure.SPEXPmidT.value           = DYNexposure.LOCexp.midTones
        DYNexposure.SPEXPscale.value          = DYNexposure.LOCexp.physicalScale
        DYNexposure.CBEXPcheck1.checked       = DYNexposure.LOCexp.chromaticAdaptation
        DYNexposure.CBEXPcheck2.checked       = DYNexposure.LOCexp.colorDifferentiation
        DYNexposure.CBEXPcheck3.checked       = DYNexposure.LOCexp.indirectOnly
        DYNexposure.CBEXPcheck4.checked       = DYNexposure.LOCexp.exteriorDaylight
        DYNexposure.CODYNcolor.color          = DYNexposure.LOCexp.whiteColor
      )

      --- For Pseudo Color Exposure Control
      if classof DYNexposure.LOCexp == Pseudo_Color_Exposure_Control then
      (
        DYNexposure.DDDYNexposures.selection  = 4
        DYNexposure.GBEXPgroup02.height       = 126
        DYNexposure.CBEXPcheck1.pos           = [2019,238]
        DYNexposure.CODYNcolor.pos            = [2141,215]; DYNexposure.CODYNcolor.enabled = false
        DYNexposure.LBEXPbright.pos           = [13,104]
        DYNexposure.LBEXPcontr.pos            = [13,125]
        DYNexposure.SPEXPbright.pos           = [(DYNiniExplorerWidth - 39),103]
        DYNexposure.SPEXPcontr.pos            = [(DYNiniExplorerWidth - 39),124]
        DYNexposure.CBEXPcheck2.pos           = [2019,258]
        DYNexposure.SPEXPvalue.pos            = [2109,171]
        DYNexposure.SPEXPmidT.pos             = [2109,192]
        DYNexposure.SPEXPscale.pos            = [(DYNiniExplorerWidth - 39),171]
        DYNexposure.LBEXPvalue.pos            = [2019,172]
        DYNexposure.LBEXPmidT.pos             = [2019,193]
        DYNexposure.LBEXPscale.pos            = [13,172]
        DYNexposure.LBDYN1.pos                = [13,201]
        DYNexposure.LBDYN2.pos                = [13,228]
        DYNexposure.LBDYN3.pos                = [13,255]
        DYNexposure.DDDYN1.pos                = [(DYNiniExplorerWidth - 110),197]
        DYNexposure.DDDYN2.pos                = [(DYNiniExplorerWidth - 110),224]
        DYNexposure.DDDYN3.pos                = [(DYNiniExplorerWidth - 110),251]
        DYNexposure.GBEXPgroup01.text         = DYNuiResourcesGroups[93]
        DYNexposure.LBEXPbright.text          = DYNuiResourcesLabels[301]
        DYNexposure.LBEXPcontr.text           = DYNuiResourcesLabels[302]
        DYNexposure.SPEXPbright.range         = [0,200000,DYNexposure.LOCexp.minimum]
        DYNexposure.SPEXPcontr.range          = [0,200000,DYNexposure.LOCexp.maximum]
        DYNexposure.SPEXPvalue.value          = 0   ; DYNexposure.SPEXPvalue.enabled = false;  DYNexposure.LBEXPvalue.enabled = false
        DYNexposure.SPEXPmidT.value           = 0.01; DYNexposure.SPEXPmidT.enabled = false;   DYNexposure.LBEXPmidT.enabled = false
        DYNexposure.SPEXPscale.value          = DYNexposure.LOCexp.physicalScale
        DYNexposure.DDDYN1.items              = #(DYNuiResourcesLabels[318], DYNuiResourcesLabels[319])
        DYNexposure.DDDYN2.items              = #(DYNuiResourcesLabels[320], DYNuiResourcesLabels[321])
        DYNexposure.DDDYN3.items              = #(DYNuiResourcesLabels[322], DYNuiResourcesLabels[323])
        DYNexposure.DDDYN1.enabled            = true
        DYNexposure.DDDYN2.enabled            = true
        DYNexposure.DDDYN3.enabled            = true
        DYNexposure.DDDYN1.selection          = DYNexposure.LOCexp.quantity + 1
        DYNexposure.DDDYN2.selection          = DYNexposure.LOCexp.display + 1
        DYNexposure.DDDYN3.selection          = DYNexposure.LOCexp.scaleFunction + 1
      )

      --- For Automatic Exposure Control
      if classof DYNexposure.LOCexp == Automatic_Exposure_Control then
      (
        /*
        Sets a physical scale for exposure control to use. This is a light intensity value, in candelas. It can range from 0.0 to 200,000.0.
        The physical scale is factored into light multiplier values, and self-illumination, reflection, and refraction maps. Default=1500.0.
        Decreasing the physical scale dims the scene. Increasing the physical scale increases brightness,
        up to a scale value at which the scene grows no brighter.
        */
        DYNexposure.DDDYNexposures.selection  = 5
        DYNexposure.GBEXPgroup02.height       = 109
        DYNexposure.SPEXPvalue.pos            = [(DYNiniExplorerWidth - 39),171]
        DYNexposure.LBEXPbright.pos           = [13,104]
        DYNexposure.SPEXPbright.pos           = [(DYNiniExplorerWidth - 39),103]
        DYNexposure.SPEXPcontr.pos            = [(DYNiniExplorerWidth - 39),124]
        DYNexposure.LBEXPcontr.pos            = [13,125]
        DYNexposure.CODYNcolor.pos            = [(DYNiniExplorerWidth - 57),215]
        DYNexposure.SPEXPmidT.pos             = [2159,192]
        DYNexposure.LBEXPmidT.pos             = [2019,193]
        DYNexposure.LBEXPvalue.pos            = [13,172]
        DYNexposure.SPEXPscale.pos            = [(DYNiniExplorerWidth - 39),192]
        DYNexposure.LBEXPscale.pos            = [13,193]
        DYNexposure.CBEXPcheck1.pos           = [13,218]
        DYNexposure.CBEXPcheck2.pos           = [13,238]
        DYNexposure.LBEXPbright.text          = DYNuiResourcesLabels[281]
        DYNexposure.LBEXPcontr.text           = DYNuiResourcesLabels[282]
        DYNexposure.SPEXPbright.range         = [0,200,DYNexposure.LOCexp.brightness]
        DYNexposure.SPEXPcontr.range          = [0,100,DYNexposure.LOCexp.contrast]
        DYNexposure.SPEXPvalue.value          = DYNexposure.LOCexp.exposureValue
        DYNexposure.SPEXPmidT.value           = 0.01; DYNexposure.SPEXPmidT.enabled = false;   DYNexposure.LBEXPmidT.enabled = false
        DYNexposure.SPEXPscale.value          = DYNexposure.LOCexp.physicalScale
        DYNexposure.CBEXPcheck1.checked       = DYNexposure.LOCexp.chromaticAdaptation
        DYNexposure.CBEXPcheck2.checked       = DYNexposure.LOCexp.colorDifferentiation
        DYNexposure.CODYNcolor.color          = DYNexposure.LOCexp.whiteColor
      )

      --- For mr Photographic Exposure Control
      if classof DYNexposure.LOCexp == mr_Photographic_Exposure_Control then
      (
        DYNexposure.DDDYNexposures.selection  = 6
        DYNexposure.GBEXPgroup01.text         = DYNuiResourcesGroups[91]
        DYNexposure.GBEXPgroup02.text         = DYNuiResourcesGroups[92]
        DYNexposure.GBEXPgroup02.pos          = [4,248]
        DYNexposure.GBEXPgroup01.height       = 156
        DYNexposure.GBEXPgroup02.height       = 150
        DYNexposure.DDDYNpreset.pos.x         = 13
        DYNexposure.RBDYNexpMode.pos.x        = 13
        DYNexposure.SPDYNexposureV.pos.x      = (DYNiniExplorerWidth - 39)
        DYNexposure.LBDYNshutter.pos.x        = 13
        DYNexposure.SPDYNshutter.pos.x        = (DYNiniExplorerWidth - 39)
        DYNexposure.LBDYNfStop.pos.x          = 13
        DYNexposure.SPDYNfStop.pos.x          = (DYNiniExplorerWidth - 39)
        DYNexposure.LBDYNfilmISO.pos.x        = 13
        DYNexposure.SPDYNfilmISO.pos.x        = (DYNiniExplorerWidth - 39)
        DYNexposure.LBDYNhighlights.pos.x     = 13
        DYNexposure.SPDYNhighlights.pos.x     = (DYNiniExplorerWidth - 39)
        DYNexposure.LBDYNmidtones.pos.x       = 13
        DYNexposure.SPDYNmidtones.pos.x       = (DYNiniExplorerWidth - 39)
        DYNexposure.LBDYNshadows.pos.x        = 13
        DYNexposure.SPDYNshadows.pos.x        = (DYNiniExplorerWidth - 39)
        DYNexposure.LBDYNsaturation.pos.x     = 13
        DYNexposure.SPDYNsaturation.pos.x     = (DYNiniExplorerWidth - 39)
        DYNexposure.LBDYNwhitepointKelvin.pos.x= 13
        DYNexposure.SPDYNwhitepointKelvin.pos.x= (DYNiniExplorerWidth - 39)
        DYNexposure.LBDYNvignetting.pos.x     = 13
        DYNexposure.SPDYNvignetting.pos.x     = (DYNiniExplorerWidth - 39)

        DYNexposure.GBDYNgroup03.pos.x        = 4
        DYNexposure.RBDYNphysicalMode.pos.x   = 13
        DYNexposure.SPDYNphysicalScale.pos.x  = (DYNiniExplorerWidth - 39)

        DYNexposure.DDDYNpreset.selection     = DYNexposure.LOCexp.preset + 2
        DYNexposure.RBDYNexpMode.state        = DYNexposure.LOCexp.exposure_mode + 1
        DYNexposure.SPDYNexposureV.enabled    = if DYNexposure.LOCexp.exposure_mode == 1 then false else true
        DYNexposure.SPDYNshutter.enabled      = DYNexposure.SPDYNfStop.enabled = DYNexposure.SPDYNfilmISO.enabled = not DYNexposure.SPDYNexposureV.enabled
        DYNexposure.SPDYNexposureV.value      = DYNexposure.LOCexp.exposure_value
        DYNexposure.SPDYNshutter.value        = DYNexposure.LOCexp.shutter_speed
        DYNexposure.SPDYNfStop.value          = DYNexposure.LOCexp.f_stop
        DYNexposure.SPDYNfilmISO.value        = DYNexposure.LOCexp.film_isoUI
        DYNexposure.SPDYNhighlights.value     = DYNexposure.LOCexp.burn_highlights
        DYNexposure.SPDYNmidtones.value       = DYNexposure.LOCexp.midtones
        DYNexposure.SPDYNshadows.value        = DYNexposure.LOCexp.shadows
        DYNexposure.SPDYNsaturation.value     = DYNexposure.LOCexp.saturation
        DYNexposure.SPDYNwhitepointKelvin.value= DYNexposure.LOCexp.whitepointKelvin
        DYNexposure.SPDYNvignetting.value     = DYNexposure.LOCexp.vignetting
        DYNexposure.RBDYNphysicalMode.state   = DYNexposure.LOCexp.physical_scale_mode + 1
        DYNexposure.SPDYNphysicalScale.value  = DYNexposure.LOCexp.physical_scale
        DYNexposure.SPDYNphysicalScale.enabled= if DYNexposure.LOCexp.physical_scale_mode == 0 then false else true

        /*
          <..>.preset Integer default: 5 -- integer; Exposure_presets
            Get/set the Exposure Preset in the drop-down list.
            Possible values are:
            0 - Physically Based Lighting, Outdoor Daylight, Clear Sky
            1 - Physically Based Lighting, Outdoor Nighttime
            2 - Physically Based Lighting, Indoor Daylight
            3 - Physically Based Lighting, Indoor Nighttime
            4 - Non Physically Base Lighting
            5 - [Select a preset] (default)

          <..>.exposure_mode Integer default: 1 -- integer
            Get/set the state of the Exposure Mode radio buttons.
            Possible values are:
            0 - Exposure Value (EV)
            1 - Photographic Exposure

          <..>.exposure_value Float default: 10.0 -- animatable; float
            Get/set the Exposure Value.

          <..>.shutter_speed Float default: 125.0 -- animatable; float
            Get/set the Shutter Speed in 1/N sec.

          <..>.f_stop Float default: 16.0 -- animatable; float; Aperture
            Get/set the Aperture (f-stop) value in f/N.

          <..>.film_isoUI Float default: 100.0 -- animatable; float; Film_Speed
            Get/set the Film Speed value (ISO) as exposed to the UI. This is the animatable value shown in the User Interface.

          <..>.burn_highlights Float default: 0.25 -- animatable; float; Highlights
            Get/set the Highlights (Burn) value.

          <..>.midtones Float default: 1.0 -- animatable; float
            Get/set the Midtones value.

          <..>.shadows Float default: 0.2 -- animatable; float
            Get/set the Shadows value.

          <..>.saturation Float default: 1.0 -- animatable; float
            Get/set the Color Saturation value.

          <..>.whitepoint Color default: (color 255 255 255) -- fRGBA color
            Get/set the Whitepoint as a color value.

          <..>.whitepointKelvin Float default: 6500.0 -- animatable; float; Whitepoint_in_color_temperature
            Get/set the Whitepoint value in Kelvin.

          <..>.vignetting Float default: 0.0 -- animatable; float
            Get/set the Vignetting value.

          <..>.physical_scale_mode Integer default: 0 -- integer
            Get/set the state of the Physical scale mode radio buttons.
            Possible values are:
            0 - Physical Units (cd/m2)
            1 - Unitless

          <..>.physical_scale Float default: 1500.0 -- animatable; float
        */
      )
    )
  )

  ---SECTION 3 - DEFINE PANEL LAYOUT---
  dropdownlist DDDYNexposures align:#left width:(DYNiniExplorerWidth - 21) pos:[4,8]
  checkbox CBEXPonoff  align:#left pos:[4,41]
  checkbox CBEXPprocBG align:#left pos:[4,61]

  --- Std Controls
  groupbox GBEXPgroup01 width:(DYNiniExplorerWidth - 21) height:62 pos:[4,85]
  spinner SPEXPbright pos:[(DYNiniExplorerWidth - 96),103] fieldwidth:60 range:[0,200,0] scale:0.1 align:#left
  spinner SPEXPcontr  pos:[(DYNiniExplorerWidth - 96),124] fieldwidth:60 range:[0,100,0] scale:0.1 align:#left
  label LBEXPbright   pos:[13,104]  width:80 align:#left
  label LBEXPcontr    pos:[13,125]  width:80 align:#left

  groupbox GBEXPgroup02 width:(DYNiniExplorerWidth - 21) height:149 pos:[4,153]
  spinner SPEXPvalue  pos:[(DYNiniExplorerWidth - 96),171] fieldwidth:60 range:[-5,5,0]   scale:0.1 align:#left
  spinner SPEXPmidT   pos:[(DYNiniExplorerWidth - 96),192] fieldwidth:60 range:[0.01,20,0]   scale:0.1 align:#left
  spinner SPEXPscale  pos:[(DYNiniExplorerWidth - 96),213] fieldwidth:60 range:[0.001,200000,100] scale:10.0 align:#left
  label LBEXPvalue    pos:[13,172]  width:80 align:#left
  label LBEXPmidT     pos:[13,193]  width:80 align:#left
  label LBEXPscale    pos:[13,214]  width:80 align:#left
  colorpicker CODYNcolor fieldwidth:30 height:20 pos:[141,215]

  label LBDYN1 align:#left width:70 pos:[19,201]
  label LBDYN2 align:#left width:70 pos:[19,228]
  label LBDYN3 align:#left width:70 pos:[19,255]
  dropdownlist DDDYN1 align:#right width:85 pos:[(DYNiniExplorerWidth - 110),197]
  dropdownlist DDDYN2 align:#right width:85 pos:[(DYNiniExplorerWidth - 110),224]
  dropdownlist DDDYN3 align:#right width:85 pos:[(DYNiniExplorerWidth - 110),251]

  checkbox CBEXPcheck1 align:#left pos:[19,238]
  checkbox CBEXPcheck2 align:#left pos:[19,258]
  checkbox CBEXPcheck3 align:#left pos:[19,278]
  checkbox CBEXPcheck4 align:#left pos:[19,298]

  --- Mr Controls
  dropdownlist DDDYNpreset           pos:[19,104] width:(DYNiniExplorerWidth - 45)
  radioButtons RBDYNexpMode          labels:#(DYNuiResourcesLabels[286], DYNuiResourcesLabels[315]) pos:[19,135] columns:1
  spinner      SPDYNexposureV        type:#float   range:[-6.0,16.0,15.0]         fieldwidth:60 align:#left scale:0.01 pos:[(DYNiniExplorerWidth - 96),133]
  label        LBDYNshutter          width:94 align:#left                                                              pos:[19,171]
  spinner      SPDYNshutter          type:#float   range:[0.0,1000000000.0,125.0] fieldwidth:60 align:#left scale:0.01 pos:[(DYNiniExplorerWidth - 96),170]
  label        LBDYNfStop            width:94 align:#left                                                              pos:[19,192]
  spinner      SPDYNfStop            type:#float   range:[1.0,128.0,16.0]         fieldwidth:60 align:#left scale:0.01 pos:[(DYNiniExplorerWidth - 96),191]
  label        LBDYNfilmISO          width:94 align:#left                                                              pos:[19,213]
  spinner      SPDYNfilmISO          type:#float   range:[10.0,10000.0,100.0]     fieldwidth:60 align:#left scale:0.01 pos:[(DYNiniExplorerWidth - 96),212]

  label        LBDYNhighlights       width:94 align:#left                                                              pos:[19,268]
  spinner      SPDYNhighlights       type:#float   range:[0.0,1.0,0.25]           fieldwidth:60 align:#left scale:0.01 pos:[(DYNiniExplorerWidth - 96),267]
  label        LBDYNmidtones         width:94 align:#left                                                              pos:[19,289]
  spinner      SPDYNmidtones         type:#float   range:[0.1,4.0,1.0]            fieldwidth:60 align:#left scale:0.01 pos:[(DYNiniExplorerWidth - 96),288]
  label        LBDYNshadows          width:94 align:#left                                                              pos:[19,310]
  spinner      SPDYNshadows          type:#float   range:[0.0,1.0,0.2]            fieldwidth:60 align:#left scale:0.01 pos:[(DYNiniExplorerWidth - 96),309]
  label        LBDYNsaturation       width:94 align:#left                                                              pos:[19,331]
  spinner      SPDYNsaturation       type:#float   range:[0.0,5.0,1.0]            fieldwidth:60 align:#left scale:0.01 pos:[(DYNiniExplorerWidth - 96),330]
  label        LBDYNwhitepointKelvin width:94 align:#left                                                              pos:[19,352]
  spinner      SPDYNwhitepointKelvin type:#float   range:[100.0,100000.0,6500.0]  fieldwidth:60 align:#left scale:0.05 pos:[(DYNiniExplorerWidth - 96),351]
  label        LBDYNvignetting       width:94 align:#left                                                              pos:[19,373]
  spinner      SPDYNvignetting       type:#float   range:[0.0,25.0,0.0]           fieldwidth:60 align:#left scale:0.01 pos:[(DYNiniExplorerWidth - 96),372]

  groupbox     GBDYNgroup03          width:(DYNiniExplorerWidth - 21) height:59 pos:[4,404]
  radiobuttons RBDYNphysicalMode     labels:#(DYNuiResourcesLabels[316], DYNuiResourcesLabels[317]) pos:[13,422]
  spinner      SPDYNphysicalScale    type:#float   range:[0.001,200000.0,1500.0]  fieldwidth:60 align:#left scale:0.01 pos:[(DYNiniExplorerWidth - 96),439]

  ---SECTION 4 - DEFINE PANEL ACTIONS---
  on DYNexposure open do
  (
    DYNexposure.title          = DYNuiRolloutNames[33]

    DDDYNpreset.items          = #(DYNuiResourcesLabels[309], DYNuiResourcesLabels[310], DYNuiResourcesLabels[311], DYNuiResourcesLabels[312], DYNuiResourcesLabels[313], DYNuiResourcesLabels[314])

    GBEXPgroup01.text          = DYNuiResourcesGroups[67]
    GBEXPgroup02.text          = DYNuiResourcesGroups[22]
    GBDYNgroup03.text          = DYNuiResourcesGroups[90]

    LBEXPbright.text           = DYNuiResourcesLabels[281]
    LBEXPcontr.text            = DYNuiResourcesLabels[282]
    LBDYNshadows.text          = DYNuiResourcesLabels[283]
    LBDYNsaturation.text       = DYNuiResourcesLabels[259]
    LBDYN3.text                = DYNuiResourcesLabels[254]
    LBDYN1.text                = DYNuiResourcesLabels[284]
    LBDYN2.text                = DYNuiResourcesLabels[285]
    LBEXPvalue.text            = DYNuiResourcesLabels[286]
    LBEXPmidT.text             = DYNuiResourcesLabels[287]
    LBDYNmidtones.text         = DYNuiResourcesLabels[287]
    LBEXPscale.text            = DYNuiResourcesLabels[288]
    LBDYNshutter.text          = DYNuiResourcesLabels[289]
    LBDYNfStop.text            = DYNuiResourcesLabels[290]
    LBDYNfilmISO.text          = DYNuiResourcesLabels[291]
    LBDYNhighlights.text       = DYNuiResourcesLabels[292]
    LBDYNwhitepointKelvin.text = DYNuiResourcesLabels[293]
    LBDYNvignetting.text       = DYNuiResourcesLabels[294]
    CBEXPonOff.text            = DYNuiResourcesLabels[295]
    CBEXPprocBG.text           = DYNuiResourcesLabels[296]
    CBEXPcheck1.text           = DYNuiResourcesLabels[297]
    CBEXPcheck2.text           = DYNuiResourcesLabels[298]
    CBEXPcheck3.text           = DYNuiResourcesLabels[299]
    CBEXPcheck4.text           = DYNuiResourcesLabels[300]

    DYNFUNsetupExpParams()
  )

  on DDDYNexposures selected arg do
  (
    if arg == 1 then SceneExposureControl.exposureControl = undefined
    if arg == 2 then SceneExposureControl.exposureControl = Linear_Exposure_Control()
    if arg == 3 then SceneExposureControl.exposureControl = Logarithmic_Exposure_Control()
    if arg == 4 then SceneExposureControl.exposureControl = Pseudo_Color_Exposure_Control()
    if arg == 5 then SceneExposureControl.exposureControl = Automatic_Exposure_Control()
    if arg == 6 then SceneExposureControl.exposureControl = mr_Photographic_Exposure_Control()
    DYNFUNsetupExpParams()
  )

  on SPEXPbright changed arg do
  (
    if classOf LOCexp == Pseudo_Color_Exposure_Control then
    (
      LOCexp.minimum = arg
    )
    else
    (
      LOCexp.brightness = arg
    )
  )

  on SPEXPcontr changed arg do
  (
    if classOf LOCexp == Pseudo_Color_Exposure_Control then
    (
      LOCexp.maximum = arg
    )
    else
    (
      LOCexp.contrast = arg
    )
  )

  on SPEXPvalue changed arg do LOCexp.exposureValue          = arg
  on SPEXPmidT  changed arg do LOCexp.midTones               = arg
  on SPEXPscale changed arg do LOCexp.physicalScale          = arg

  on DDDYN1 selected arg do DYNexposure.LOCexp.quantity      = arg - 1
  on DDDYN2 selected arg do DYNexposure.LOCexp.display       = arg - 1
  on DDDYN3 selected arg do DYNexposure.LOCexp.scaleFunction = arg - 1

  on CBEXPonOff  changed val do (LOCexp.active = val; DYNamite.dnExposeNode.forecolor = DYNFUNdnColor (if LOCexp.active then (((colorMan.getColor #text) as color) * 255) else DYNINIgreyedOutColor))
  on CBEXPprocBG changed val do (LOCexp.ProcessBG            = val)
  on CBEXPcheck1 changed val do (LOCexp.chromaticAdaptation  = val)
  on CBEXPcheck2 changed val do (LOCexp.colorDifferentiation = val)
  on CBEXPcheck3 changed val do (LOCexp.indirectOnly         = val)
  on CBEXPcheck4 changed val do (LOCexp.exteriorDaylight     = val)

  on CODYNcolor  changed arg do (LOCexp.whiteColor = arg)

  on DDDYNpreset selected arg do
  (
    LOCexp.preset                 = arg - 2
    SPDYNexposureV.value          = LOCexp.exposure_value
    SPDYNshutter.value            = LOCexp.shutter_speed
    SPDYNfStop.value              = LOCexp.f_stop
    SPDYNfilmISO.value            = LOCexp.film_isoUI
  )
  on RBDYNexpMode          changed arg do (LOCexp.exposure_mode       = arg - 1; SPDYNexposureV.enabled = if arg == 1 then true else false; SPDYNshutter.enabled = SPDYNfStop.enabled = SPDYNfilmISO.enabled = not SPDYNexposureV.enabled)
  on SPDYNexposureV        changed arg do (LOCexp.exposure_value      = arg; SPDYNshutter.value   = LOCexp.shutter_speed)
  on SPDYNshutter          changed arg do (LOCexp.shutter_speed       = arg; SPDYNexposureV.value = LOCexp.exposure_value)
  on SPDYNfStop            changed arg do (LOCexp.f_stop              = arg; SPDYNexposureV.value = LOCexp.exposure_value)
  on SPDYNfilmISO          changed arg do (LOCexp.film_isoUI          = arg; SPDYNexposureV.value = LOCexp.exposure_value)
  on SPDYNhighlights       changed arg do LOCexp.burn_highlights      = arg
  on SPDYNmidtones         changed arg do LOCexp.midtones             = arg
  on SPDYNshadows          changed arg do LOCexp.shadows              = arg
  on SPDYNsaturation       changed arg do LOCexp.saturation           = arg
  on SPDYNwhitepointKelvin changed arg do LOCexp.whitepointKelvin     = arg
  on SPDYNvignetting       changed arg do LOCexp.vignetting           = arg
  on RBDYNphysicalMode     changed arg do (LOCexp.physical_scale_mode = arg - 1; SPDYNphysicalScale.enabled = if arg == 1 then false else true)
  on SPDYNphysicalScale    changed arg do LOCexp.physical_scale       = arg
)
